/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.core;

import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.core.Core;
import icyllis.modernui.graphics.Bitmap;
import icyllis.modernui.util.LongSparseArray;
import java.lang.ref.Reference;
import java.nio.IntBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

@NotThreadSafe
public class Window
implements AutoCloseable {
    private static final LongSparseArray<Window> sWindows = new LongSparseArray();
    public static final int LAST_SYSTEM_WINDOW = 2999;
    protected final long mHandle;

    public Window(long handle) {
        Core.checkMainThread();
        this.mHandle = handle;
        if (sWindows.put(handle, this) != null) {
            throw new IllegalStateException("Duplicated window: 0x" + Long.toHexString(handle));
        }
    }

    @Nullable
    public static Window get(@NativeType(value="GLFWwindow *") long handle) {
        return sWindows.get(handle);
    }

    @NativeType(value="GLFWwindow *")
    public final long getHandle() {
        return this.mHandle;
    }

    public boolean shouldClose() {
        return GLFW.glfwWindowShouldClose((long)this.mHandle);
    }

    public void setShouldClose(boolean value) {
        GLFW.glfwSetWindowShouldClose((long)this.mHandle, (boolean)value);
    }

    public void setTitle(@NonNull String title) {
        GLFW.glfwSetWindowTitle((long)this.mHandle, (CharSequence)title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIcon(Bitmap ... icons) {
        if (icons == null || icons.length == 0) {
            GLFW.nglfwSetWindowIcon((long)this.mHandle, (int)0, (long)0L);
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            GLFWImage.Buffer images = GLFWImage.malloc((int)icons.length, (MemoryStack)stack);
            for (int i = 0; i < icons.length; ++i) {
                Bitmap icon = icons[i];
                images.position(i);
                images.width(icon.getWidth());
                images.height(icon.getHeight());
                MemoryUtil.memPutAddress((long)(images.address() + (long)GLFWImage.PIXELS), (long)icon.getAddress());
            }
            images.flip();
            GLFW.glfwSetWindowIcon((long)this.mHandle, (GLFWImage.Buffer)images);
        }
        finally {
            Reference.reachabilityFence(icons);
        }
    }

    public void makeCurrent() {
        GLFW.glfwMakeContextCurrent((long)this.mHandle);
    }

    public void swapBuffers() {
        GLFW.glfwSwapBuffers((long)this.mHandle);
    }

    public void swapInterval(int interval) {
        GLFW.glfwSwapInterval((int)interval);
    }

    public int getWidth() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer w = stack.mallocInt(1);
            GLFW.glfwGetFramebufferSize((long)this.mHandle, (IntBuffer)w, null);
            int n = w.get(0);
            return n;
        }
    }

    public int getHeight() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer h = stack.mallocInt(1);
            GLFW.glfwGetFramebufferSize((long)this.mHandle, null, (IntBuffer)h);
            int n = h.get(0);
            return n;
        }
    }

    public int getScreenY() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer w = stack.mallocInt(1);
            GLFW.glfwGetWindowPos((long)this.mHandle, (IntBuffer)w, null);
            int n = w.get(0);
            return n;
        }
    }

    public int getScreenX() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer h = stack.mallocInt(1);
            GLFW.glfwGetWindowPos((long)this.mHandle, null, (IntBuffer)h);
            int n = h.get(0);
            return n;
        }
    }

    public int getScreenWidth() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer w = stack.mallocInt(1);
            GLFW.glfwGetWindowSize((long)this.mHandle, (IntBuffer)w, null);
            int n = w.get(0);
            return n;
        }
    }

    public int getScreenHeight() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer h = stack.mallocInt(1);
            GLFW.glfwGetWindowSize((long)this.mHandle, null, (IntBuffer)h);
            int n = h.get(0);
            return n;
        }
    }

    public void minimize() {
        GLFW.glfwIconifyWindow((long)this.mHandle);
    }

    public void restore() {
        GLFW.glfwRestoreWindow((long)this.mHandle);
    }

    public void maximize() {
        GLFW.glfwMaximizeWindow((long)this.mHandle);
    }

    public void show() {
        GLFW.glfwShowWindow((long)this.mHandle);
    }

    public void hide() {
        GLFW.glfwHideWindow((long)this.mHandle);
    }

    @Override
    public void close() {
        Window w = sWindows.remove(this.mHandle);
        if (w == null) {
            return;
        }
        assert (w == this);
        Callbacks.glfwFreeCallbacks((long)this.mHandle);
        GLFW.glfwDestroyWindow((long)this.mHandle);
    }

    public static enum State {
        WINDOWED,
        FULLSCREEN,
        FULLSCREEN_BORDERLESS,
        MAXIMIZED,
        MINIMIZED;

    }
}

